define([
    'underscore',
    'backbone',
    'modules/new-appointment-request/resources/direct/preferred-date/time-slots-by-date-collection',
    'moment',
], function (_, Backbone, TimeSlotsByDateCollection, moment) {
    'use strict';

    var TimeSlotsByMonthModel = Backbone.Model.extend({
        toJSON: function() {
            var jsObject = _.clone(this.attributes);
            if (!_.isUndefined(jsObject.timeSlotsByDateCollection)) {
                jsObject.timeSlotsByDateCollection = jsObject.timeSlotsByDateCollection.toJSON();
            }

            return jsObject;
        },
    });

    // collection
    return Backbone.Collection.extend({
        model: TimeSlotsByMonthModel,
        comparator: function(model) {
            return new Date(model.get('date'));
        },
        initialize: function(models, options) {
            var timeSlotsByDate;
            var groupedTimeSlots;
            var firstDayOfMonth;

            if (!_.isUndefined(options.fromTimeSlotsByDateCollection)) {
                // initialize from a TimeSlotsByDateCollection
                timeSlotsByDate = options.fromTimeSlotsByDateCollection.models;
                groupedTimeSlots = _.groupBy(timeSlotsByDate, function(dateGroup) {
                    // date in format mm/dd/yyyy
                    return moment(dateGroup.get('date')).format('MMMM-YYYY');
                });


                _.each(_.keys(groupedTimeSlots), function(monthYearString) {
                    firstDayOfMonth = moment('01 ' + monthYearString, 'DD MMMM-YYYY').startOf('day')
                        .toDate();

                    this.add({
                        date: firstDayOfMonth,
                        id: monthYearString.toLowerCase(),
                        monthNameYear: monthYearString.replace('-', ' '),
                        timeSlotsByDateCollection: new TimeSlotsByDateCollection(groupedTimeSlots[monthYearString]),
                    });
                }.bind(this));
            }
        },
    });
});
